/*******************************************************************
*
*  DESCRIPTION: Atomic Model MovementController
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 07/08/2009
*******************************************************************/

/** include files **/
#include <math.h>            // fabs( ... )
#include <stdlib.h>
#include "MovementController.h"  // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include "commonH.h"

/*******************************************************************
* Function Name: MovementController
* Description: constructor
********************************************************************/
MovementController::MovementController( const std::string &name ) : Atomic( name )
, mctrl_sctrl_in( addInputPort( "mctrl_sctrl_in" ) )
, mctrl_sctrl_out( addInputPort( "mctrl_sctrl_out" ) )
, mctrl_moveR_out( addOutputPort( "mctrl_moveR_out" ) )
, mctrl_moveL_out( addOutputPort( "mctrl_moveL_out" ) )
, movePrepTime (00,00,00,10)
, turnTime (00,00,01,00)
{
	std::string movepreparation_str( MainSimulator::Instance().getParameter( description(), "movePrepTime" ) ) ;
	std::string turnTime_str( MainSimulator::Instance().getParameter( description(), "turnTime" ) ) ;

	//test
	if (movepreparation_str !="") movePrepTime = movepreparation_str;
	if (turnTime_str !="") turnTime = turnTime_str;
	
	cout<<"movePrepTime="<<movePrepTime<<"\n";
	cout<<"turnTime="<<turnTime<<"\n";
}

/*******************************************************************
* Function Name: MovementController::initFunction()
* Description: Initialization Function
********************************************************************/
Model &MovementController::initFunction()
{
	state = IDLE;		// waiting event
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: MovementController::externalFunction()
* Description: External Function MovementController
********************************************************************/
Model &MovementController::externalFunction( const ExternalMessage &msg )
{	
	cout << "--> In MCTRL ExtFunc() / state= " << state;
	
	if (msg.port() == mctrl_sctrl_in) {
			
		sctrl_input = static_cast<int>(msg.value());
		
		cout << "/ port= mctrl_sctrl_in / value= " << sctrl_input;
		
		if (sctrl_input == STOP_PROC) {
			state = PREP_STOP;
			holdIn( Atomic::active, ZERO_TIME );
		}
		
		else if (sctrl_input == ON_TRACK) {

			if (state == WAIT_DATA || state == IDLE) {
				state = PREP_MOVE_FWD;
				holdIn( Atomic::active, movePrepTime );
			}	
		}
		
		else if (sctrl_input == OFF_TRACK) {
		
			if (state == MOVE_FWD) {
				state = MX_STOP;
				holdIn( Atomic::active, ZERO_TIME );
			}
			else if (state == WAIT_DATA || state == IDLE) {
				state = PREP_TURN;
				holdIn( Atomic::active, movePrepTime );
			}	
		}
	}
	
	cout << "/ new state= " << state << "\n";

	return *this;
}

/*******************************************************************
* Function Name: MovementController::internalFunction()
* Description: Internal Function MovementController
********************************************************************/
Model &MovementController::internalFunction( const InternalMessage & )
{
	cout << "<----- In MCTRL IntFunc() / state= " << state;
	
	switch (state){
		case PREP_MOVE_FWD:
			state = MOVE_FWD;
			passivate();
			break;

		case MX_STOP:
			state = PREP_TURN;
			holdIn( Atomic::active, movePrepTime );
			break;

		case PREP_TURN:
			state = TURN_ALPHA;
		    holdIn( Atomic::active, turnTime );
			break;
			
		case TURN_ALPHA:
			state = WAIT_DATA;
			passivate();
			break;

		case PREP_STOP:
			state = IDLE;
			passivate();
			break;
			
		default:
			break;
	}
	
	cout << "/ new state= " << state << "\n";
	
	return *this;
}

/*******************************************************************
* Function Name: MovementController::outputFunction()
* Description: Output function MovementController - writes info about time and events
********************************************************************/
Model &MovementController::outputFunction( const InternalMessage &msg )
{
	cout << "<----- In MCTRL OutFunc() / state= " << state;
	
	if (state==PREP_MOVE_FWD)
	{
		sendOutput( msg.time(), mctrl_moveR_out, COMMON_H::O_GO_FWD) ;
		sendOutput( msg.time(), mctrl_moveL_out, COMMON_H::O_GO_FWD) ;
		
		cout << "/ sent " << COMMON_H::O_GO_FWD << " to mctrl_X_out\n";
	}

	else if(state== MX_STOP || state==TURN_ALPHA || state== PREP_STOP)
	{
		sendOutput( msg.time(), mctrl_moveR_out, COMMON_H::O_STOP) ;
		sendOutput( msg.time(), mctrl_moveL_out, COMMON_H::O_STOP) ;
		
		cout << "/ sent " << COMMON_H::O_STOP << " to mctrl_X_out\n";
	}

	else if (state== PREP_TURN)
	{
		sendOutput( msg.time(), mctrl_moveR_out, COMMON_H::O_GO_FWD) ;
		sendOutput( msg.time(), mctrl_moveL_out, COMMON_H::O_GO_REV) ;
		
		cout << "/ sent turn signal to mctrl_X_out\n";
	}
		
	return *this ;
}

MovementController::~MovementController()
{
	//MainSimulator::Instance().Spin_Motor_Stop();
}
